require( "scripts/style.lua" )

HeaderFont = {
  standardFont,
  35,
  BlackColor
};

TableInfoFont = {
  standardFont,
  30,
 BlackColor
};

ErrorFont = {
  standardFont,
  24,
 BlackColor
};

AccountFont = {
  standardFont,
  18,
  BlackColor
};

ScoreFont = {
  standardFont,
  16,
  BlackColor
};

HiscoreSubmitLegal = {
  standardFont,
  14,
  BlackColor
};

kPlayerNameY = 115;
kScoreY = 160;
kYourPFAccountY = 220;
kAccountNameY = 245;
kEditOffsetY = 13;
kPasswordY = 290;
kRememberY = 335;
kTextOffsetX = 125;
kEditBoxOffsetX = 118;

kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'privacy_info';
end


function SwitchModes( submit )

	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end

	EnableWindow("header",not submit and gMedalsMode == false);
	EnableWindow("headermedals", not submit and gMedalsMode == true);
	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit and gMedalsMode == false);
	EnableWindow("yourscore", not submit and gMedalsMode == false);
	EnableWindow("eligiblescore", not submit and gMedalsMode == false);
	EnableWindow("scorebox", not submit and gMedalsMode == false);
	
	EnableWindow("yourpfaccount", not submit and fullHS);
	EnableWindow("nametext", not submit and fullHS);
	EnableWindow("passtext", not submit and fullHS);

	EnableWindow("nameeditbox", not submit  and gMedalsMode == false);
	EnableWindow("accounteditbox", not submit and fullHS);
	EnableWindow("passeditbox", not submit and fullHS);
	EnableWindow("remember", not submit and fullHS);

	EnableWindow("submittoserver", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitconnect", submit);

end

ServerSubmitEditStyle=
{
	parent=DefaultStyle,
	font = { standardFont, 16, BlackColor},
	x=0,y=kCenter,
	w=kMax,h=32,
	flags=kVAlignCenter
};

local offsetY = 0;

function UpdateOffsetY()
	if gMedalsMode then
		offsetY = -80;
	end
end

UpdateOffsetY();

MakeDialog
{
	name="hiscoresubmitscreen",
	Bitmap
	{
		image="backgrounds/largedialog",
		mask = exists("backgrounds/largedialog.mask.png"),
		x=kCenter,
		y=kCenter,
		SubmitWindow
		{
			x=0,y=0,h=kMax,w=kMax,
			SetStyle(DefaultStyle);
			Text
			{
				font = HeaderFont,
				name = "header",
				x=120,y=30,w=kMax-130,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "submitglobal"
			};
			
			Text
			{
				font = HeaderFont,
				name = "headermedals",
				x=120,y=30,w=kMax-130,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "submitmedals"
			};

			Text
			{
				font = AccountFont,
				name = "playertext",
				x=kTextOffsetX,y=kPlayerNameY,w=145,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "playerlabel"
			};

			Text
			{
				font = AccountFont,
				name = "yourscore",
				x=kTextOffsetX,y=kScoreY,w=250,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "scorelabel"
			};
			
			Bitmap
			{
				name="scorebox",
				image="buttons/choosenameup",
				mask=exists("buttons/choosenameup.mask.png"),
				label="",
				x=kEditBoxOffsetX,
				y=kScoreY+kEditOffsetY,
			};

			Text
			{
				font = AccountFont,
				name = "eligiblescore",
				x=205,y=kScoreY+kEditOffsetY+7,w=100,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = gEligibleScore
			};

			Text
			{
				font = AccountFont,
				name = "yourpfaccount",
				x=kTextOffsetX,y=kYourPFAccountY+offsetY,w=250,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "yourpfaccount"
			};

			Text
			{
				font = AccountFont,
				name = "nametext",
				x=kTextOffsetX,y=kAccountNameY+offsetY,w=145,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "namelabel"
			};

			Text
			{
				font = AccountFont,
				name = "passtext",
				x=kTextOffsetX,y=kPasswordY+offsetY,w=145,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "passwordlabel"
			};

			Text
			{
				font = TableInfoFont,
				name = "submitconnect",
				x=0,y=0,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignCenter,
				label = "connectingtoserver"
			};

			Text
			{
				font = ErrorFont,
				name = "submiterror",
				x=120,y=0,w=kMax-120,h=kMax,
				flags = kHAlignCenter + kVAlignCenter,
				label = "errormessage"
			};

			Bitmap
			{
				name="nameeditbox",
				image="buttons/choosenameup",
				mask=exists("buttons/choosenameup.mask.png"),
				x=kEditBoxOffsetX,
				y=kPlayerNameY+kEditOffsetY+offsetY,

				SetStyle(ServerSubmitEditStyle),
				TextEdit
				{
					x = 10,
					name = "nameedit",
					utf8=false, -- the hiscore servers only take low-ASCII names
					label = gNameEdit,
					length=21,
					ignore = kIllegalNameChars
				};
			};

			Bitmap
			{
				name="accounteditbox",
				image="buttons/choosenameup",
				mask=exists("buttons/choosenameup.mask.png"),
				x=kEditBoxOffsetX,
				y=kAccountNameY+kEditOffsetY+offsetY,

				SetStyle(ServerSubmitEditStyle),
				TextEdit
				{
					x = 10,
					name = "accountedit",
					utf8=false, -- the hiscore servers only take low-ASCII names
					label= gAccountEdit,
					length=21,
					ignore = kIllegalNameChars
				};
			};

			Bitmap
			{
				name="passeditbox",
				image="buttons/choosenameup",
				mask=exists("buttons/choosenameup.mask.png"),
				x=kEditBoxOffsetX,
				y=kPasswordY+kEditOffsetY+offsetY,

				SetStyle(ServerSubmitEditStyle),
				TextEdit
				{
					x = 10,
					name = "passedit",
					label= gPassEdit,
					utf8=true,
					password = true,
					length=26
				};
			};

			SetStyle( CheckboxButtonStyle ),
			Button
			{
				x=135, y=kRememberY+offsetY,

				name="remember",
				label = "",
				type = kToggle,
				w=260,
				h=30,
				scale=1,
				rollover = "",
				drop = false,
				sound = "audio/sfx/checkbox.ogg",
				Text
				{
					font = StandardButtonFont,
					name = "rememberlabel",
					x=20,
					y=5,
					w=250,
					h=25,
					flags = kHAlignLeft + kVAlignTop,
					label="rememberpfaccount",
				};
			};

			SetStyle( ThinButtonStyle ),
			Button
			{
				x=kCenter-70, y=kMax-70,

				name="submittoserver",
				label="submit",
				hotkey="alt-s", -- override the hot key here so it doesn't steal our TTextEdit keys
				type = kPush,
				default= true, -- this should be the default button (on enter)

				command =
					function()
						name = GetLabel("nameedit");
						account = GetLabel("accountedit");
						pass = GetLabel("passedit");
						remember = GetButtonToggleState("remember");
						SubmitToServer(name,account,pass,remember,gMedalsMode);
					end
			},

			Button
			{
				x=kCenter+70, y=kMax-70,

				name="submitcancel",
				label="cancel",
				cancel = true,
				type = kPush,
				command =
					function()
						PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
					end
			};

			Button
			{
				x=kCenter, y=kMax-70,

				name="submiterrorok",
				label="ok",
				type = kPush,
				command=
					function()
						EnableWindow("submiterrorok",false);
						EnableWindow("submiterror",false);
						SwitchModes(false);
					end
			};

			Button
			{
				x=0,
				y=0,
				w=0,
				h=0,
				graphics={},
				name="privacybutton",
				command =
					function()
						if (IsEnabled(kHiscoreAnonymous)) then
							DisplayDialog {
								"scripts/ok.lua",
								body ="privacy_anon",
								title = ""
							};
						else
							LaunchPrivacyPolicy();
						end
					end
			};

			Text
			{
				x = 115, w = kMax-100,
				y = 365+offsetY, h = kMax,
				font = HiscoreSubmitLegal;
				flags = kHAlignLeft + kVAlignTop,
				label = kPrivacyLabel
			};
		}
	}
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
SetButtonToggleState('remember',gRemember);
if (gMedalsMode) then
	SetFocus("accountedit");
else
	SetFocus("nameedit");
end
SwitchModes(false);